#Cuadro IX.1
#Test t para muestras independientes.

##############################################
#Seccin modificable por el usuario
##############################################

#Lectura de datos.
datos<-read.csv2("Cuadro IX.1.V.csv",header=TRUE,encoding="latin1")

#Seleccin variable dependiente. En caso de que se deseen utilizar valores transformados, desmarcamos la transformacin que nos interese como "NULL".
varInteres<-c("Peso")
#varInteres<-c("Altura")

#Seleccin de un tipo de transformacin para las variables de inters. Si no se transforma la variable debe mantenerse la opcin "NULL".
varInteres1X2<-NULL
varInteres1X<-NULL
varInteresLN<-NULL
varInteresLOG10<-NULL
varInteresSQR<-NULL
varInteresX2<-NULL
varInteresX3<-NULL
varInteresEX<-NULL
varInteresASN<-NULL

#varInteres1X2<-c(1,1)
#varInteres1X<-c(1,1)
#varInteresLN<-c(1,1)
#varInteresLOG10<-c(1,1)
#varInteresSQR<-c(1,1)
#varInteresX2<-c(1,1)
#varInteresX3<-c(1,1)
#varInteresEX<-c(1,1)
#varInteresASN<-c(1,1)

#Variable que corresponde al factor.
varPoblacion<-c("Pas")

#Seleccin de grupos a comparar en el factor.
varComparar1<-c("Espaa")
varComparar2<-c("Italia")
#varComparar1<-NULL

##Variables de seleccin. 
#Los elementos de las listas varSeleccion pueden modificarse en funcin de nuestros intereses.
#Pueden escogerse hasta dos grupos en cada variable de seleccin, en un nmero igual o inferior al n total de grupos - 1
varSeleccion1<-list(c("Sexo","Nio"))
#varSeleccion1<-NULL
varSeleccion2<-list(c("Edad","2","3"))
#varSeleccion2<-NULL

#Archivo de salida.
ArchivodeSalida<-"Salida Cuadro IX.1.txt"

###############################################
#Seccin que realiza el procedimiento
###############################################

#Paquetes necesarios
require(lawstat)
require(e1071)

##Organizacin de los datos.
datos1<-na.omit(datos)
valores<-(datos1[,varInteres])
if (length(varInteres1X2)==2) valores<-1/((datos1[,varInteres])^2)
if (length(varInteres1X)==2) valores<-1/(datos1[,varInteres])
if (length(varInteresLN)==2) valores<-log(datos1[,varInteres])
if (length(varInteresLOG10)==2) valores<-log10(datos1[,varInteres])
if (length(varInteresSQR)==2) valores<-sqrt((datos1[,varInteres]))
if (length(varInteresX2)==2) valores<-(datos1[,varInteres])^2
if (length(varInteresX3)==2) valores<-(datos1[,varInteres])^3
if (length(varInteresEX)==2) valores<-exp(datos1[,varInteres])
if (length(varInteresASN)==2) valores<-asin((datos1[,varInteres]))
poblaciones<-(datos1[,varPoblacion])

#Selecciones
if (length(varSeleccion1)!=0){
 w1<-data.frame(row.names=1:dim(datos1)[1])
 varBin1<-as.character()
 for (i in 1:length(varSeleccion1)){
   nom1<-varSeleccion1[[i]][1]
   x1<-factor(datos1[,nom1])
   if (length(varSeleccion1[[i]])>1){
      sufijo1<-paste(varSeleccion1[[i]][2:3],collapse="_")
      nom1<-paste(nom1,".",sufijo1,sep="")
      x11<-factor(ifelse(x1 %in% varSeleccion1[[i]][2:3],as.character(x1),NA))
      x11<-data.frame(factor(x11))
   }else{
      x11<-x1
      x11<-data.frame(x1)
   }
   names(x11)<-nom1
   varBin1<-c(varBin1,nom1)
   w1<-data.frame(w1,x11)
 }
}

if (length(varSeleccion2)!=0){
 w2<-data.frame(row.names=1:dim(datos1)[1])
 varBin2<-as.character()
 for (i in 1:length(varSeleccion2)){
   nom2<-varSeleccion2[[i]][1]
   x2<-factor(datos1[,nom2])
   if (length(varSeleccion2[[i]])>1){
      sufijo2<-paste(varSeleccion2[[i]][2:3],collapse="_")
      nom2<-paste(nom2,".",sufijo2,sep="")
      x12<-factor(ifelse(x2 %in% varSeleccion2[[i]][2:3],as.character(x2),NA))
      x12<-data.frame(factor(x12))
   }else{
      x12<-x2
      x12<-data.frame(x2)
   }
   names(x12)<-nom2
   varBin2<-c(varBin2,nom2)
   w2<-data.frame(w2,x12)
 }
}

if ((length(varSeleccion1)!=0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w1,w2)
if ((length(varSeleccion1)!=0)&(length(varSeleccion2)==0)) seleccion<-data.frame(w1)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w2)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)==0)) seleccion<-NULL

#Preparacin de los conjuntos de datos para el anlisis
if (length(seleccion)==0) datos2<-data.frame(poblaciones,valores)
if (length(seleccion)!=0) datos2<-data.frame(seleccion,poblaciones,valores)
datos2<-na.omit(datos2)
if (length(varComparar1)==1) {datos3a<-data.frame(datos2[(datos2$poblaciones==varComparar1),])
                             datos3b<-data.frame(datos2[(datos2$poblaciones==varComparar2),])
                             datos3<-data.frame(rbind(datos3a,datos3b))
}
if (length(varComparar1)==0) datos3<-data.frame(datos2)

##Pruebas
#Prueba de normalidad (test de Shapiro-Wilks).
PruebaNormalidad<-by(datos3[,"valores"],datos3[,"poblaciones"],shapiro.test)
 
#Prueba de heterocedasticidad (test de Levene).
PruebaHeterocedasticidadMedia<-levene.test(datos3$valores,datos3$poblaciones,location="mean")
PruebaHeterocedasticidadMediana<-levene.test(datos3$valores,datos3$poblaciones,location="median")

#Estudio del sesgo y curtosis.
Sesgodatos<-c("Sesgo",by(datos3[,"valores"],datos3[,"poblaciones"],skewness))
Curtosisdatos<-c("Curtosis", by(datos3[,"valores"],datos3[,"poblaciones"],kurtosis,type=2))

#Test de la "t".
TestT<-t.test(datos3$valores~datos3$poblaciones)

###############################################
#Seccin que muestra los resultados
###############################################

Resultados<-list(PruebaNormalidad,PruebaHeterocedasticidadMedia,PruebaHeterocedasticidadMediana,Sesgodatos,Curtosisdatos,TestT)

if(!is.null(ArchivodeSalida)){
 sink(ArchivodeSalida)
 print(Resultados)
 sink()
}
